/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.placement.handlers.placement;

import com.ldtteam.structurize.api.util.IRotatableBlockEntity;
import com.ldtteam.structurize.api.util.ItemStackUtils;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.schematic.BlockFluidSubstitution;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.PlacementSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirtPathBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.DragonEggBlock;
import net.minecraft.world.level.block.EndPortalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public final class PlacementHandlers {
    public static final List<IPlacementHandler> handlers = new ArrayList<IPlacementHandler>();

    public static void add(IPlacementHandler handler, Class<?> override) {
        for (int i = 0; i < handlers.size(); ++i) {
            if (!override.isInstance(handlers.get(i))) continue;
            handlers.set(i, handler);
            return;
        }
        PlacementHandlers.add(handler);
    }

    public static void add(IPlacementHandler handler) {
        handlers.add(1, handler);
    }

    private PlacementHandlers() {
    }

    public static void handleTileEntityPlacement(CompoundTag tileEntityData, Level world, BlockPos pos, PlacementSettings settings) {
        BlockEntity newTile;
        if (tileEntityData != null && (newTile = BlockEntity.m_155241_((BlockPos)pos, (BlockState)world.m_8055_(pos), (CompoundTag)tileEntityData)) != null) {
            BlockEntity worldBlockEntity = world.m_7702_(pos);
            if (worldBlockEntity != null) {
                worldBlockEntity.m_142466_(newTile.m_187480_());
                worldBlockEntity.m_6596_();
            } else {
                world.m_151523_(newTile);
            }
            world.m_8055_(pos).rotate((LevelAccessor)world, pos, settings.rotation);
            world.m_8055_(pos).m_60715_(settings.mirror);
            if (newTile instanceof IRotatableBlockEntity) {
                ((IRotatableBlockEntity)newTile).rotate(settings.rotation);
                ((IRotatableBlockEntity)newTile).mirror(settings.mirror);
            }
        }
    }

    public static List<ItemStack> getRequiredItemsForState(Level world, BlockPos pos, BlockState state, CompoundTag data, boolean complete) {
        for (IPlacementHandler placementHandler : handlers) {
            if (!placementHandler.canHandle(world, pos, state)) continue;
            return placementHandler.getRequiredItems(world, pos, state, data, complete);
        }
        return Collections.emptyList();
    }

    public static void handleTileEntityPlacement(CompoundTag tileEntityData, Level world, BlockPos pos) {
        PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos, new PlacementSettings());
    }

    public static List<ItemStack> getItemsFromTileEntity(CompoundTag tileEntityData, BlockState blockState) {
        if (tileEntityData == null) {
            return Collections.emptyList();
        }
        try {
            return ItemStackUtils.getItemStacksOfTileEntity(tileEntityData, blockState);
        }
        catch (Exception ex) {
            return Collections.emptyList();
        }
    }

    static {
        handlers.add(new AirPlacementHandler());
        handlers.add(new FluidSubstitutionPlacementHandler());
        handlers.add(new FirePlacementHandler());
        handlers.add(new BlockGrassPathPlacementHandler());
        handlers.add(new GrassPlacementHandler());
        handlers.add(new DoorPlacementHandler());
        handlers.add(new BedPlacementHandler());
        handlers.add(new DoublePlantPlacementHandler());
        handlers.add(new SpecialBlockPlacementAttemptHandler());
        handlers.add(new FlowerPotPlacementHandler());
        handlers.add(new StairBlockPlacementHandler());
        handlers.add(new HopperClientLagPlacementHandler());
        handlers.add(new ContainerPlacementHandler());
        handlers.add(new FallingBlockPlacementHandler());
        handlers.add(new BannerPlacementHandler());
        handlers.add(new GeneralBlockPlacementHandler());
    }

    public static class AirPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.m_60734_() instanceof AirBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
            if (!world.m_46859_(pos)) {
                List entityList = world.m_6443_(Entity.class, new AABB(pos), entity -> !(entity instanceof LivingEntity) && !(entity instanceof ItemEntity));
                if (!entityList.isEmpty()) {
                    for (Entity entity2 : entityList) {
                        entity2.m_142687_(Entity.RemovalReason.KILLED);
                    }
                }
                world.m_7471_(pos, false);
            }
            return IPlacementHandler.ActionProcessingResult.PASS;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            return new ArrayList<ItemStack>();
        }
    }

    public static class FluidSubstitutionPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.m_60734_() instanceof BlockFluidSubstitution;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            if (complete) {
                items.add(new ItemStack((ItemLike)blockState.m_60734_()));
            } else if (BlockUtils.getFluidForDimension(world).m_60734_() == Blocks.f_49991_) {
                items.add(new ItemStack((ItemLike)Items.f_42448_));
            }
            return items;
        }

        @Override
        public void handleRemoval(IStructureHandler handler, Level world, BlockPos pos, CompoundTag tileEntityData) {
            BlockState state = world.m_8055_(pos);
            if (!state.m_61138_((Property)BlockStateProperties.f_61362_) || ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() || BlockUtils.getFluidForDimension(world).m_60734_() != Blocks.f_49990_) {
                this.handleRemoval(handler, world, pos);
            }
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
            if (complete) {
                world.m_7731_(pos, ((BlockFluidSubstitution)((Object)ModBlocks.blockFluidSubstitution.get())).m_49966_(), 3);
                return IPlacementHandler.ActionProcessingResult.PASS;
            }
            if (world.m_8055_(pos).m_61138_((Property)BlockStateProperties.f_61362_)) {
                world.m_7731_(pos, (BlockState)world.m_8055_(pos).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)), 3);
            } else {
                world.m_7731_(pos, BlockUtils.getFluidForDimension(world), 3);
            }
            return IPlacementHandler.ActionProcessingResult.PASS;
        }
    }

    public static class FirePlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.m_60734_() instanceof FireBlock;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(new ItemStack((ItemLike)Items.f_42409_, 1));
            return itemList;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
            world.m_7731_(pos, blockState, 3);
            return IPlacementHandler.ActionProcessingResult.PASS;
        }
    }

    public static class BlockGrassPathPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.m_60734_() instanceof DirtPathBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
            if (!world.m_7731_(pos, Blocks.f_152481_.m_49966_(), 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(new ItemStack((ItemLike)Blocks.f_50493_, 1));
            return itemList;
        }
    }

    public static class GrassPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.m_60734_() == Blocks.f_50440_ || blockState.m_60734_() != Blocks.f_50493_ && blockState.m_204336_(BlockTags.f_144274_) && Blocks.f_50493_ == blockState.m_60734_();
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
            if (!world.m_7731_(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(new ItemStack((ItemLike)Blocks.f_50493_));
            return itemList;
        }
    }

    public static class DoorPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.m_60734_() instanceof DoorBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
            if (((DoubleBlockHalf)blockState.m_61143_((Property)DoorBlock.f_52730_)).equals((Object)DoubleBlockHalf.LOWER)) {
                world.m_7731_(pos, (BlockState)blockState.m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER), 3);
                world.m_7731_(pos.m_7494_(), (BlockState)blockState.m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.UPPER), 3);
            }
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            if (((DoubleBlockHalf)blockState.m_61143_((Property)DoorBlock.f_52730_)).equals((Object)DoubleBlockHalf.LOWER)) {
                itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            }
            return itemList;
        }
    }

    public static class BedPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.m_60734_() instanceof BedBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
            if (blockState.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD) {
                Direction facing = (Direction)blockState.m_61143_((Property)BedBlock.f_54117_);
                world.m_7731_(pos.m_142300_(facing.m_122424_()), (BlockState)blockState.m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.FOOT), 3);
                world.m_7731_(pos, (BlockState)blockState.m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD), 3);
                if (tileEntityData != null) {
                    PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos);
                    PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos.m_142300_(facing.m_122424_()));
                }
                return IPlacementHandler.ActionProcessingResult.SUCCESS;
            }
            return IPlacementHandler.ActionProcessingResult.PASS;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            if (blockState.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD) {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                list.add(new ItemStack((ItemLike)blockState.m_60734_(), 1));
                return list;
            }
            return Collections.emptyList();
        }
    }

    public static class DoublePlantPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.m_60734_() instanceof DoublePlantBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
            if (((DoubleBlockHalf)blockState.m_61143_((Property)DoublePlantBlock.f_52858_)).equals((Object)DoubleBlockHalf.LOWER)) {
                world.m_7731_(pos, (BlockState)blockState.m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER), 3);
                world.m_7731_(pos.m_7494_(), (BlockState)blockState.m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER), 3);
                return IPlacementHandler.ActionProcessingResult.SUCCESS;
            }
            return IPlacementHandler.ActionProcessingResult.PASS;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            return itemList;
        }
    }

    public static class SpecialBlockPlacementAttemptHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.m_60734_() instanceof EndPortalBlock || blockState.m_60734_() instanceof SpawnerBlock || blockState.m_60734_() instanceof DragonEggBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
            return IPlacementHandler.ActionProcessingResult.PASS;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            return new ArrayList<ItemStack>();
        }
    }

    public static class FlowerPotPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.m_60734_() instanceof FlowerPotBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
            if (world.m_8055_(pos).m_60734_() == blockState.m_60734_()) {
                return IPlacementHandler.ActionProcessingResult.PASS;
            }
            if (!world.m_7731_(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            if (tileEntityData != null) {
                PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos);
            }
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            itemList.add(new ItemStack((ItemLike)((FlowerPotBlock)blockState.m_60734_()).m_53560_()));
            itemList.removeIf(ItemStackUtils::isEmpty);
            return itemList;
        }
    }

    public static class StairBlockPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.m_60734_() instanceof StairBlock && !(blockState.m_60734_() instanceof EntityBlock) && world.m_8055_(pos).m_60734_() instanceof StairBlock && world.m_8055_(pos).m_61143_((Property)StairBlock.f_56841_) == blockState.m_61143_((Property)StairBlock.f_56841_) && blockState.m_60734_() == world.m_8055_(pos).m_60734_();
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
            return IPlacementHandler.ActionProcessingResult.PASS;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            return new ArrayList<ItemStack>();
        }
    }

    public static class HopperClientLagPlacementHandler
    extends ContainerPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.m_60734_() instanceof HopperBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
            boolean flag = !world.m_46753_(pos);
            return super.handle(world, pos, flag != (Boolean)blockState.m_61143_((Property)HopperBlock.f_54022_) ? (BlockState)blockState.m_61124_((Property)HopperBlock.f_54022_, (Comparable)Boolean.valueOf(flag)) : blockState, tileEntityData, complete, centerPos);
        }
    }

    public static class ContainerPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.m_60734_() instanceof BaseEntityBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
            if (!world.m_7731_(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            try {
                ItemStackUtils.getItemStacksOfTileEntity(tileEntityData, blockState);
            }
            catch (Exception ex) {
                return IPlacementHandler.ActionProcessingResult.SUCCESS;
            }
            if (tileEntityData != null) {
                PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos);
            }
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            itemList.addAll(PlacementHandlers.getItemsFromTileEntity(tileEntityData, blockState));
            itemList.removeIf(ItemStackUtils::isEmpty);
            return itemList;
        }
    }

    public static class FallingBlockPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.m_60734_() instanceof FallingBlock;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(PlacementHandlers.getItemsFromTileEntity(tileEntityData, blockState));
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            itemList.removeIf(ItemStackUtils::isEmpty);
            if (!world.m_8055_(pos.m_7495_()).m_60767_().m_76333_()) {
                BlockPos posBelow = pos;
                BlockState supportBlockState = Blocks.f_50493_.m_49966_();
                for (int i = 0; i < 10; ++i) {
                    BlockState possibleSupport = BlockUtils.getWorldgenBlock(world, posBelow = posBelow.m_7495_(), (BlockState)(i == 0 ? blockState : null));
                    if (!possibleSupport.m_60767_().m_76333_() || possibleSupport.m_60734_() instanceof FallingBlock || possibleSupport.m_60734_() instanceof Fallable) continue;
                    supportBlockState = possibleSupport;
                    break;
                }
                itemList.addAll(PlacementHandlers.getRequiredItemsForState(world, pos, supportBlockState, tileEntityData, complete));
            }
            return itemList;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
            if (world.m_8055_(pos).equals(blockState)) {
                return IPlacementHandler.ActionProcessingResult.PASS;
            }
            if (!world.m_8055_(pos.m_7495_()).m_60767_().m_76333_()) {
                BlockPos posBelow = pos;
                BlockState supportBlockState = Blocks.f_50493_.m_49966_();
                for (int i = 0; i < 10; ++i) {
                    BlockState possibleSupport = BlockUtils.getWorldgenBlock(world, posBelow = posBelow.m_7495_(), (BlockState)(i == 0 ? blockState : null));
                    if (!possibleSupport.m_60767_().m_76333_() || possibleSupport.m_60734_() instanceof FallingBlock || possibleSupport.m_60734_() instanceof Fallable) continue;
                    supportBlockState = possibleSupport;
                    break;
                }
                world.m_7731_(pos.m_7495_(), supportBlockState, 3);
            }
            if (!world.m_7731_(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            if (tileEntityData != null) {
                PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos);
            }
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }
    }

    public static class BannerPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.m_60734_() instanceof BannerBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
            if (world.m_8055_(pos).equals(blockState)) {
                if (tileEntityData != null) {
                    PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos);
                }
                return IPlacementHandler.ActionProcessingResult.PASS;
            }
            if (!world.m_7731_(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            if (tileEntityData != null) {
                PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos);
                blockState.m_60734_().m_6402_(world, pos, blockState, null, BlockUtils.getItemStackFromBlockState(blockState));
            }
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(PlacementHandlers.getItemsFromTileEntity(tileEntityData, blockState));
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            itemList.removeIf(ItemStackUtils::isEmpty);
            return itemList;
        }
    }

    public static class GeneralBlockPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return true;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos, PlacementSettings settings) {
            if (world.m_8055_(pos).equals(blockState)) {
                world.m_7471_(pos, false);
                world.m_7731_(pos, blockState, 3);
                if (tileEntityData != null) {
                    PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos, settings);
                }
                return IPlacementHandler.ActionProcessingResult.PASS;
            }
            if (!world.m_7731_(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            if (tileEntityData != null) {
                PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos, settings);
            }
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(PlacementHandlers.getItemsFromTileEntity(tileEntityData, blockState));
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            itemList.removeIf(ItemStackUtils::isEmpty);
            return itemList;
        }
    }
}

